import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the diagram
fig, ax = plt.subplots(figsize=(12, 4))

# Colors for statuses
clear_color = 'green'
not_clear_color = 'red'

# Curb positions
curb_positions = [0, 1, 2, 3, 4, 5, 6]

# Define curbs
curbs = {
    0: {'cars': ['car6', 'car7'], 'status': 'not clear'},
    1: {'cars': ['car1', 'car8'], 'status': 'not clear'},
    2: {'cars': ['car9', 'car4'], 'status': 'not clear'},
    3: {'cars': ['car3'], 'status': 'clear'},
    4: {'cars': ['car0'], 'status': 'clear'},
    5: {'cars': ['car5'], 'status': 'clear'},
    6: {'cars': ['car2'], 'status': 'clear'}
}

# Draw curbs and cars
for i, position in enumerate(curb_positions):
    # Draw curb
    curb_color = not_clear_color if curbs[position]['status'] == 'not clear' else clear_color
    curb_rect = patches.Rectangle((i * 1.5, 0), 1, 2, linewidth=1, edgecolor='black', facecolor=curb_color)
    ax.add_patch(curb_rect)
    ax.text(i * 1.5 + 0.5, 1.8, f'curb_{position}', ha='center', va='center', color='black', fontsize=10)
    
    # Draw cars
    for j, car in enumerate(curbs[position]['cars']):
        car_color = not_clear_color if j == 0 else clear_color
        car_circle = patches.Circle((i * 1.5 + 0.5, 1 - 0.5 * j), 0.2, linewidth=1, edgecolor='black', facecolor=car_color)
        ax.add_patch(car_circle)
        ax.text(i * 1.5 + 0.5, 1 - 0.5 * j, f'{car}', ha='center', va='center', color='white', fontsize=8)

# Create legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear'),
    patches.Patch(facecolor=not_clear_color, edgecolor='black', label='Not Clear')
]
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and remove axes
ax.set_xlim(-0.5, 10)
ax.set_ylim(-1, 3)
ax.axis('off')

# Save the figure
plt.savefig('parking/one_shot/ini_diagram_code/attempts/attempt_21.png')
plt.show()